<?php $__env->startSection('title', 'Form'); ?>
<?php $__env->startSection('content'); ?>

    <div class="main-content">
        <section class="section">
            <div class="section-header">
                <h1><?php echo e(__('Manage Languages')); ?></h1>
                <div class="section-header-breadcrumb">
                    <div class="breadcrumb-item active"><a href="<?php echo e(route('home')); ?>"><?php echo e(__('Dashboard')); ?></a></div>
                    <div class="breadcrumb-item"><?php echo e(__('Languages')); ?></div>
                </div>
            </div>

            <div class="section-body">

                <div id="output-status"></div>
                <div class="row">
                    <div class="col-md-12 p-0 m-0">
                        <div class="card p-o">
                            <div class="card-header">
                                <div class="col-lg-6  custom_left">

                                    <h4><?php echo e(__('Language')); ?></h4>
                                </div>
                                <div class="col-lg-6  custom_right">

                                    <a href="#!" class="btn float-right btn-danger text-light btn-lg" data-toggle="tooltip" data-original-title="<?php echo e(__('Delete')); ?>" 
                                    data-confirm="<?php echo e(__('Are You Sure?').' | '.__('This action can not be undone. Do you want to continue?')); ?>"
                                     data-confirm-yes="document.getElementById('delete-form-<?php echo e($currantLang); ?>').submit();">
                                        <i class="fas fa-trash"></i> <?php echo e(__('Delete')); ?>

                                    </a>
                                    <?php echo Form::open(['method' => 'DELETE', 'route' => ['lang.destroy', $currantLang],'id'=>'delete-form-'.$currantLang]); ?>

                                    <?php echo Form::close(); ?>

                                    <a href="<?php echo e(route('create.language', [$currantLang])); ?>" class="btn float-right btn-primary text-light btn-lg" id="create">Create</a>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="card">

                            <div class="card-body">
                                <ul class="nav nav-pills flex-column">
                                    <?php $__currentLoopData = $languages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $lang): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    
                                        <li class="nav-item">
                                            <a href="<?php echo e(route('manage.language', [$lang])); ?>"
                                                class="nav-link <?php echo e($currantLang == $lang ? 'active' : ''); ?>"><?php echo e(Str::upper($lang)); ?></a>
                                        </li>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </ul>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-8">
                        <div class="card" id="settings-card">

                                <div class="card-body">
                                    <ul class="nav nav-tabs" id="myTab" role="tablist">
                                        <li class="nav-item shadow mb-3 mr-2">
                                            <a class="nav-link active" id="account-details-tab" data-toggle="tab"
                                                href="#account-details" role="tab" aria-controls="account-details"
                                                aria-selected="false"><?php echo e(__('Labels')); ?></a>
                                        </li>
                                        <li class="nav-item shadow mb-3 mr-2">
                                            <a class="nav-link" id="login-details-tab" data-toggle="tab" href="#login-details"
                                                role="tab" aria-controls="login-details"
                                                aria-selected="false"><?php echo e(__('Message')); ?></a>
                                        </li>
                                    </ul>
                                    <div class="tab-content mt-3 mx-0">
                                        <div class="tab-pane active" id="account-details" role="tabpanel"
                                            aria-labelledby="account-details-tab">
                                            <form method="post" class="form-horizontal" action="<?php echo e(route('store.language.data',[$currantLang])); ?>">
                                                <?php echo csrf_field(); ?>
                                                <div class="row form-group">
                                                    <?php $__currentLoopData = $arrLabel; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $label => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <div class="col-md-6">
                                                            <div class="mt-3">
                                                                <label class="form-control-label" for="example3cols1Input"><?php echo e($label); ?> </label>
                                                                <input type="text" class="form-control" name="label[<?php echo e($label); ?>]" value="<?php echo e($value); ?>">
                                                            </div>
                                                        </div>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                    <div class="col-lg-12 text-right mt-3">
                                                        <button type="submit" class="btn btn-primary"><?php echo e(__('Save Changes')); ?></button>

                                                    </div>

                                                </div>
                                            </form>
                                        </div>
                                        <div class="tab-pane" id="login-details" role="tabpanel"
                                            aria-labelledby="login-details-tab">
                                            <form method="post" action="<?php echo e(route('store.language.data',[$currantLang])); ?>">
                                                <?php echo csrf_field(); ?>
                                                <div class="row form-group">
                                                    <?php $__currentLoopData = $arrMessage; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $fileName => $fileValue): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <div class="col-lg-12">
                                                            <h3><?php echo e(ucfirst($fileName)); ?></h3>
                                                        </div>
                                                        <?php $__currentLoopData = $fileValue; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $label => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                            <?php if(is_array($value)): ?>
                                                                <?php $__currentLoopData = $value; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $label2 => $value2): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                    <?php if(is_array($value2)): ?>
                                                                        <?php $__currentLoopData = $value2; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $label3 => $value3): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                            <?php if(is_array($value3)): ?>
                                                                                <?php $__currentLoopData = $value3; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $label4 => $value4): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                                    <?php if(is_array($value4)): ?>
                                                                                        <?php $__currentLoopData = $value4; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $label5 => $value5): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                                            <div class="col-md-6">
                                                                                                <div class="mt-3">
                                                                                                    <label class="form-control-label"><?php echo e($fileName); ?>.<?php echo e($label); ?>.<?php echo e($label2); ?>.<?php echo e($label3); ?>.<?php echo e($label4); ?>.<?php echo e($label5); ?></label>
                                                                                                    <input type="text" class="form-control" name="message[<?php echo e($fileName); ?>][<?php echo e($label); ?>][<?php echo e($label2); ?>][<?php echo e($label3); ?>][<?php echo e($label4); ?>][<?php echo e($label5); ?>]" value="<?php echo e($value5); ?>">
                                                                                                </div>
                                                                                            </div>
                                                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                                                    <?php else: ?>
                                                                                        <div class="col-lg-6">
                                                                                            <div class="mt-3">
                                                                                                <label class="form-control-label"><?php echo e($fileName); ?>.<?php echo e($label); ?>.<?php echo e($label2); ?>.<?php echo e($label3); ?>.<?php echo e($label4); ?></label>
                                                                                                <input type="text" class="form-control" name="message[<?php echo e($fileName); ?>][<?php echo e($label); ?>][<?php echo e($label2); ?>][<?php echo e($label3); ?>][<?php echo e($label4); ?>]" value="<?php echo e($value4); ?>">
                                                                                            </div>
                                                                                        </div>
                                                                                    <?php endif; ?>
                                                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                                            <?php else: ?>
                                                                                <div class="col-lg-6">
                                                                                    <div class="mt-1">
                                                                                        <label class="form-control-label"><?php echo e($fileName); ?>.<?php echo e($label); ?>.<?php echo e($label2); ?>.<?php echo e($label3); ?></label>
                                                                                        <input type="text" class="form-control" name="message[<?php echo e($fileName); ?>][<?php echo e($label); ?>][<?php echo e($label2); ?>][<?php echo e($label3); ?>]" value="<?php echo e($value3); ?>">
                                                                                    </div>
                                                                                </div>
                                                                            <?php endif; ?>
                                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                                    <?php else: ?>
                                                                        <div class="col-lg-6">
                                                                            <div class="mt-1">
                                                                                <label class="form-control-label"><?php echo e($fileName); ?>.<?php echo e($label); ?>.<?php echo e($label2); ?></label>
                                                                                <input type="text" class="form-control" name="message[<?php echo e($fileName); ?>][<?php echo e($label); ?>][<?php echo e($label2); ?>]" value="<?php echo e($value2); ?>">
                                                                            </div>
                                                                        </div>
                                                                    <?php endif; ?>
                                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                            <?php else: ?>
                                                                <div class="col-lg-6">
                                                                    <div class="mt-1">
                                                                        <label class="form-control-label"><?php echo e($fileName); ?>.<?php echo e($label); ?></label>
                                                                        <input type="text" class="form-control" name="message[<?php echo e($fileName); ?>][<?php echo e($label); ?>]" value="<?php echo e($value); ?>">
                                                                    </div>
                                                                </div>
                                                            <?php endif; ?>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </div>
                                                <div class="col-lg-12 text-right mt-3">
                                                    <button type="submit" class="btn btn-primary"><?php echo e(__('Save Changes')); ?></button>
                                                </div>
                                            </form>
                                        </div>
                                    </div>
                                </div>
                                
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </section>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startPush('style'); ?>
    <link href="<?php echo e(asset('assets/modules/bootstrap-tagsinput/dist/bootstrap-tagsinput.css')); ?>" rel="stylesheet" />
<?php $__env->stopPush(); ?>


<?php $__env->startPush('script'); ?>
    <script src="<?php echo e(asset('assets/modules/bootstrap-tagsinput/dist/bootstrap-tagsinput.min.js')); ?>"></script>
    <script>
        $(".inputtags").tagsinput('items');
        $(".custom_select").select2();
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\laragon\www\virtual_card\resources\views/lang/index.blade.php ENDPATH**/ ?>