<?php
$user = \Auth::user();

?>


<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">

    <link rel="stylesheet" href="<?php echo e(asset('assets/front/css/index.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('assets/front/css/header.css')); ?>">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@4.6.0/dist/css/bootstrap.min.css" crossorigin="anonymous">
    <link rel="stylesheet" href="<?php echo e(asset('assets/modules/izitoast/css/iziToast.min.css ')); ?>">
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Montserrat:ital,wght@0,100..900;1,100..900&display=swap" rel="stylesheet">
    <script src="https://code.jquery.com/jquery-3.5.1.slim.min.js" crossorigin="anonymous"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@4.6.0/dist/js/bootstrap.bundle.min.js" crossorigin="anonymous"></script>
    <script src="https://code.jquery.com/jquery-3.5.1.slim.min.js" crossorigin="anonymous"></script>
    <script src="https://cdn.jsdelivr.net/npm/popper.js@1.16.1/dist/umd/popper.min.js" crossorigin="anonymous"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@4.6.0/dist/js/bootstrap.min.js" crossorigin="anonymous"></script>
    <link rel="stylesheet" href="<?php echo e(asset('assets/front/css/header.css')); ?>">

    <title><?php echo $__env->yieldContent('title'); ?> | <?php echo e(Utility::getsettings('app_name')); ?></title>
    <?php echo $__env->yieldPushContent('css'); ?>
</head>
<script>
    <!-- Start of LiveChat (www.livechat.com) code 
    -->
    window.__lc
    =
    window.__lc
    ||
    {};
    window.__lc.license
    =
    17335251;;
    (function(n,
    t,
    c)
    {
    function
    i(n)
    {
    return
    e._h
    ?
    e._h.apply(null,
    n)
    :
    e._q.push(n)
    }
    var
    e
    =
    {
    _q:
    [],
    _h:
    null,
    _v:
    "2.0",
    on:
    function()
    {
    i(["on",
    c.call(arguments)])
    },
    once:
    function()
    {
    i(["once",
    c.call(arguments)])
    },
    off:
    function()
    {
    i(["off",
    c.call(arguments)])
    },
    get:
    function()
    {
    if
    (!e._h)
    throw
    new
    Error("[LiveChatWidget]
    You
    can
    't
    use
    getters
    before
    load.
    ");
    return
    i(["get",
    c.call(arguments)])
    },
    call:
    function()
    {
    i(["call",
    c.call(arguments)])
    },
    init:
    function()
    {
    var
    n
    =
    t.createElement("script");
    n.async
    =
    !0,
    n.type
    =
    "text/javascript",
    n.src
    =
    "https://cdn.livechatinc.com/tracking.js",
    t.head.appendChild(n)
    }
    };
    !n.__lc.asyncInit
    &&
    e.init(),
    n.LiveChatWidget
    =
    n.LiveChatWidget
    ||
    e
    }(window,
    document,
    [].slice))
</script>
<noscript><a href="https://www.livechat.com/chat-with/17335251/" rel="nofollow">Chat with us</a>, powered by <a href="https://www.livechat.com/?welcome" rel="noopener nofollow" target="_blank">LiveChat</a></noscript>
<!-- End of LiveChat code -->



<body>
    <div class="header">
        <div class="header-container">
            <div class="logo-cont">
                <a href="<?php echo e(route('front')); ?>"><img src="<?php echo e(asset('assets/front/images/logo-white.png')); ?>" alt=""></a>
            </div>

            <div class="header-otp">
                <!-- <div class="opt-box">
                    <h3>9658751258 </h3><img src="phone.svg" alt="">
                </div> -->
                <div class="opt-box">
                    <a style="display: flex; align-items: center; gap: 8px;" href="<?php echo e(route('brochures')); ?>">
                        <h3>Brochures</h3> <img src="<?php echo e(asset('assets/front/svg/book.svg')); ?>" alt="">
                    </a>
                </div>
                <!-- <div class="opt-box">
                   <h3> My booking</h3> <img src="svg/booking.svg" alt="">
                </div> -->
                <?php if(!$user): ?>
                <div class="opt-box agent_login">
                    <h3> Agent login</h3><img src="<?php echo e(asset('assets/front/svg/agent.svg')); ?>" alt="">
                </div>
                <?php endif; ?>
                <!-- <div class="opt-box">
                    <h3>Search</h3><img src="search.svg" alt="">
                </div> -->
                <div class="menu">
                    <strong>Menu</strong>
                    <img src="<?php echo e(asset('assets/front/images/burger-bar.png')); ?>" alt="">
                </div>
            </div>
        </div>

        <div class="hover-menu-container">
            <div class="options-wrapper">
                <div class="select-option">
                    <h3 class="dropdown-title">Destination <img src="<?php echo e(asset('assets/front/images/down-arrow.png')); ?>" alt=""></h3>
                    <div class="dropdown-content ">
                        <ul>
                            <a href="<?php echo e(route('destination','usa')); ?>">
                                <li>Usa <img src="<?php echo e(asset('assets/front/images/follow-arrow.png')); ?>" alt=""></li>
                            </a>
                            <a href="<?php echo e(route('destination','australia')); ?>">
                                <li>Australia <img src="<?php echo e(asset('assets/front/images/follow-arrow.png')); ?>" alt=""></li>
                            </a>
                            <a href="<?php echo e(route('destination','canada')); ?>">
                                <li>Canada <img src="<?php echo e(asset('assets/front/images/follow-arrow.png')); ?>" alt=""></li>
                            </a>
                            <a href="<?php echo e(route('destination','new-zealand')); ?>">
                                <li>New Zealand <img src="<?php echo e(asset('assets/front/images/follow-arrow.png')); ?>" alt=""></li>
                            </a>
                        </ul>
                    </div>
                </div>
                <div class="select-option ">
                    <h3 class="dropdown-title">Offers <img src="<?php echo e(asset('assets/front/images/down-arrow.png')); ?>" alt=""></h3>
                    <div class="dropdown-content ">
                        <ul>
                            <a href="<?php echo e(route('offers')); ?>">
                                <li>Offer <img src="<?php echo e(asset('assets/front/images/follow-arrow.png')); ?>" alt=""></li>
                            </a>
                        </ul>
                    </div>
                </div>
                <div class="select-option">
                    <h3 class="dropdown-title">Faq's <img src="<?php echo e(asset('assets/front/images/down-arrow.png')); ?>" alt=""></h3>
                    <div class="dropdown-content ">
                        <ul>
                            <a href="<?php echo e(route('faqs')); ?>">
                                <li>Faq <img src="<?php echo e(asset('assets/front/images/follow-arrow.png')); ?>" alt=""></li>
                            </a>
                        </ul>
                    </div>
                </div>
            </div>
        </div>

    </div>

    <?php echo $__env->make('front.include.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>


    <?php echo $__env->yieldContent('content'); ?>

    <?php echo $__env->make('front.include.menu', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>







    <?php echo $__env->make('front.include.login-signup', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>




    <script src="<?php echo e(asset('assets/front/js/custom.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/front/js/header.js')); ?>"></script>

    <script src="<?php echo e(asset('assets/modules/izitoast/js/iziToast.min.js')); ?>"></script>





    <script>
        <?php if(!$user): ?>
        $(document).on('click', '.agent_login', function() {
            $('#login-popup').show();
        });

        document.addEventListener("DOMContentLoaded", function() {

            //$('#login-popup').show();
            // Get references to the login and register sections
            var loginSection = document.querySelector('.login-section');
            var registerSection = document.querySelector('.register-section');

            registerSection.style.display = 'none';

            document.querySelector('.login').addEventListener('click', function() {
                loginSection.style.display = 'none';
                registerSection.style.display = 'block';
            });

            document.querySelector('.register').addEventListener('click', function() {
                loginSection.style.display = 'block';
                registerSection.style.display = 'none';
            });


        });
        <?php endif; ?>

        <?php if(session('errors')): ?>
        iziToast.error({
            title: "<?php echo e(__('Error!')); ?>",
            message: "<?php echo e(session('errors')->first()); ?>",
            position: 'topRight'
        });
        <?php endif; ?>

        <?php if(session('error')): ?>
        iziToast.error({
            title: "<?php echo e(__('Error!')); ?>",
            message: "<?php echo e(session('error')); ?>",
            position: 'topRight'
        });
        <?php endif; ?>

        <?php if(session('successful')): ?>
        iziToast.success({
            title: "<?php echo e(__('Success ')); ?>",
            message: "<?php echo e(session('successful ')); ?>",
            position: 'topRight'
        });
        <?php endif; ?>

        <?php if(session('success')): ?>
        iziToast.success({
            title: "<?php echo e(__('Success')); ?>",
            message: "<?php echo e(session('success')); ?>",
            position: 'topRight'
        });
        <?php endif; ?>
    </script>
    <?php echo $__env->yieldPushContent('javascript'); ?>
</body>

</html><?php /**PATH C:\laragon\www\journey\resources\views/layouts/main.blade.php ENDPATH**/ ?>