<?php
    $users = \Auth::user();
    $currantLang = $users->currentLanguage();
    $languages = Utility::languages();
    
    
    // $profile = asset(Storage::url('uploads/avatar/'));
?>
<div class="main-sidebar">
    <aside id="sidebar-wrapper">
        <div class="sidebar-brand">
            
            <img src="<?php echo e(Storage::url('logo/app-logo.png')); ?>" class="app-logo w-50">

        </div>
        <div class="sidebar-brand sidebar-brand-sm">
            <img src="<?php echo e(Storage::url('logo/app-small-logo.png')); ?>" class="app-logo w-50">

            

            <img src="" class="app-logo w-50">

        </div>
        <ul class="sidebar-menu pt-3">

            <li>
                <a class="nav-link" href="<?php echo e(route('home')); ?>"><i class="fas fa-fire text-primary"></i>
                    <span><?php echo e(__('Dashboard')); ?></span></a>
            </li>
            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('manage-user')): ?>
                <li>
                    <a class="nav-link" href="<?php echo e(route('users.index')); ?>"><i class="fas fa-users text-primary"></i>
                        <span><?php echo e(__('Users')); ?></span></a>
                </li>
                <li>
                    <a class="nav-link" href="<?php echo e(route('drivers.index')); ?>"><i class="fas fa-truck text-primary"></i>
                        <span><?php echo e(__('Drivers')); ?></span></a>
                </li>
            <?php endif; ?>
             <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('manage-order')): ?>
                <li>
                    <a class="nav-link" href="<?php echo e(route('orders.index')); ?>"><i class="fas fa-apple-alt text-primary"></i>
                        <span><?php echo e(__('Order')); ?></span></a>
                </li>
            <?php endif; ?>
            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('manage-setting')): ?>
                <li>
                    <a class="nav-link" href="<?php echo e(route('settings')); ?>"><i class="fas fa-pencil-ruler text-primary  "></i>
                        <span><?php echo e(__('Settings')); ?></span></a>
                </li>
            <?php endif; ?>
             
                <li class="nav-item">
                    <a class="nav-link" href="<?php echo e(route('manage.language', [$currantLang])); ?>">
                        <i class="fas fa-globe text-primary"></i>
                        <span class="nav-link-text"><?php echo e(__('Manage Language')); ?></span>
                    </a>
                </li>
            

            
        </ul>


    </aside>
</div>
<?php /**PATH C:\laragon\www\driver\resources\views/admin/menu.blade.php ENDPATH**/ ?>