<?php

use App\Http\Controllers\DriverController;
use App\Http\Controllers\FrontController;
use App\Http\Controllers\GameController;
use App\Http\Controllers\HomeController;
use App\Http\Controllers\LanguageController;
use App\Http\Controllers\ModuleController;
use App\Http\Controllers\OrderController;
use App\Http\Controllers\ProductController;
use App\Http\Controllers\ProfileController;
use App\Http\Controllers\RoleController;
use App\Http\Controllers\SettingsController;
use App\Http\Controllers\UserController;
use App\Http\Controllers\WebexMeetingController;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "web" middleware group. Make something great!
|
*/


Auth::routes();


Route::get('/', [FrontController::class, 'index'])->name('front');
Route::get('/admin', [FrontController::class, 'adminLogin'])->name('admin.login');
Route::get('/destination/{location?}', [FrontController::class, 'destinations'])->name('destination');
Route::get('/offers', [FrontController::class, 'offers'])->name('offers');
Route::get('/faqs', [FrontController::class, 'faqs'])->name('faqs');
//Brochures
Route::get('/brochures', [FrontController::class, 'brochures'])->name('brochures');

Route::group(['middleware' => ['auth']], function () {
    Route::get('/home', [HomeController::class, 'index'])->name('home');
    // Route::get('/home', [HomeController::class, 'index'])->name('home');
    Route::resource('roles', RoleController::class);
    Route::resource('profile', ProfileController::class);
    Route::resource('modules', ModuleController::class);
    Route::resource('users', UserController::class);
    Route::resource('products', ProductController::class);


    Route::get('/agency-list', [HomeController::class, 'agencyList'])->name('agency_list');
    Route::get('/prooduct-list', [HomeController::class, 'productList'])->name('product_list');
    Route::get('/withdraw-list/{user_id?}', [HomeController::class, 'withdrawList'])->name('withdraw_list');
    Route::get('/deposite-list/{user_id?}', [HomeController::class, 'depositeList'])->name('deposite_list');
    Route::get('/order-list', [HomeController::class, 'orderList'])->name('order_list');
    Route::get('/deposite', [HomeController::class, 'deposite'])->name('deposite');
    Route::post('/deposite-request', [HomeController::class, 'depositeRequest'])->name('send.deposite.request');
    Route::get('/deposite-history', [HomeController::class, 'depositeHistory'])->name('deposite.history');

    Route::get('/withdraw', [HomeController::class, 'withdraw'])->name('withdraw');
    Route::post('/withdraw-request', [HomeController::class, 'withdrawRequest'])->name('send.withdraw.request');
    Route::get('/withdraw-history', [HomeController::class, 'withdrawHistory'])->name('withdraw.history');

    Route::post('/role/{id}', [RoleController::class, 'assignPermission'])->name('roles_permit');
    Route::get('/users/{id}/bank', [UserController::class, 'bankEdit'])->name('users.bank');
    Route::patch('/users/{id}/bank-update', [UserController::class, 'bankUpdate'])->name('users.bank.update');
    Route::get('/change-withdraw-status/{id}/{status}', [UserController::class, 'changeWithStatus'])->name('change.with.status');
    Route::get('/change-deposite-status/{id}/{status}', [UserController::class, 'changeDepositeStatus'])->name('change.deposite.status');
    Route::get('/reset-journey/{id}', [UserController::class, 'resetJourney'])->name('reset.journey');
    Route::get('/settings', [SettingsController::class, 'index'])->name('settings');
    Route::post('/filter-journey', [HomeController::class, 'filterJourney'])->name('filter.journey');
    Route::post('/lock-journey/{id}', [HomeController::class, 'lockJourney'])->name('lock.journey');
    Route::get('/rate-trip', [HomeController::class, 'rateTrip'])->name('rate.trip');
    Route::get('/start-journey', [HomeController::class, 'startJourney'])->name('start.journey');
    Route::post('/submit-journey/{id}', [HomeController::class, 'submitJourney'])->name('submit.journey');
    Route::post('/incress-decress-amount', [UserController::class, 'incressDecressAmount'])->name('incress-decress-amount');
    Route::get('/resubmit-journey/{id}', [HomeController::class, 'resubmitJourney'])->name('resubmit.journey');
    Route::get('/journey-history', [HomeController::class, 'journeyHistory'])->name('journey.history');
    Route::post('settings/app-name/update', [SettingsController::class, 'appNameUpdate'])->name('settings/app-name/update');
    Route::post('settings/app-logo/update', [SettingsController::class, 'appNameUpdate'])->name('settings/app-name/update');
    Route::post('settings/pusher-setting/update', [SettingsController::class, 'pusherSettingUpdate'])->name('settings/pusher-setting/update');
    Route::post('settings/s3-setting/update', [SettingsController::class, 's3SettingUpdate'])->name('settings/s3-setting/update');
    Route::post('settings/email-setting/update', [SettingsController::class, 'emailSettingUpdate'])->name('settings/email-setting/update');
    Route::post('settings/auth-settings/update', [SettingsController::class, 'authSettingsUpdate'])->name('settings/auth-settings/update');
    Route::post('settings/level-settings/update', [SettingsController::class, 'levelSettingsUpdate'])->name('settings/level-settings/update');
    Route::get('setting/{id}', [SettingsController::class, 'loadsetting'])->name('setting');
    Route::get('update-avatar/{id}', [ProfileController::class, 'showAvatar'])->name('update-avatar');
    Route::post('update-avatar/{id}', [ProfileController::class, 'updateAvatar'])->name('update-new-avatar');
    Route::get('update-profile-login/{id}', [ProfileController::class, 'updateLogin'])->name('update-login');
    Route::get('change-language/{lang}', [LanguageController::class, 'changeLanquage'])->name('change.language');
    Route::get('manage-language/{lang}', [LanguageController::class, 'manageLanguage'])->name('manage.language');
    Route::post('store-language-data/{lang}', [LanguageController::class, 'storeLanguageData'])->name('store.language.data');
    Route::get('create-language', [LanguageController::class, 'createLanguage'])->name('create.language');
    Route::post('store-language', [LanguageController::class, 'storeLanguage'])->name('store.language');
    Route::delete('/lang/{lang}', [LanguageController::class, 'destroyLang'])->name('lang.destroy');
});
