@php
$user = \Auth::user();
@endphp
@extends('layouts.main')
@push('css')
<link rel="stylesheet" href="{{ asset('assets/front/css/page.css') }}">
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">

@endpush
@section('content')

<div class="bg02 pt-3 pb-3">
    <div class="container-fluid text-center">
        <div class="cont010 pt-3 pl-3 pr-3 pb-5">
            <div class="d-flex flex-row justify-content-between mb-5">

                <h1 class="dep">Redemption</h1>


                <a href="{{ route('withdraw.history') }}">
                    <div class="d-flex flex-row">
                        <h1 class="dep01">History</h1>
                        <img src="{{ asset('assets/front/img/chevron02.png') }}" class="che01">
                    </div>
                </a>
            </div>
            <div class="bg-container021 p-5 mb-5">
                <h6 class="t01">Assets Balance</h6>
                <h1 class="t02">USDT {{ $user->balance }}</h1>
                <h6 class=" t01">Redemption will be receive usually within an hour</h6>

            </div>

            <div class="d-flex flex-row">

                <img src="{{ asset('assets/front/img/ts.png') }}" class="ts01">
                <h1 class="dep010 mb-4">USDT Withdraw</h1>
            </div>
            <form method="POST" action="{{ route('send.withdraw.request') }}">
                @csrf
                <p class="smap text-left"> Withdrawal will be transferred to USDT Address
                </p>

                <h6 class="chain ">Chain Type</h6>
                <select class="form-control mx-auto col-md-4 mb-3" name="chain_type">
                    <option value="">Select type</option>
                    <option {{ (Auth::user()->chain_type == 'TRC20')?'selected':'' }} value="TRC20">TRC 20</option>
                    <option {{ (Auth::user()->chain_type == 'ERC20')?'selected':'' }} value="ERC20">ERC 20</option>
                </select>

                <h6 class="chain ">Address</h6>
                <input type="text" required class="form-control mx-auto col-md-4 mb-3" value="{{ Auth::user()->address }}" name="bank_card_number" placeholder="Enter your Address">

                <div class="container">


                    <div class="form-group mt-4">
                        <h6 class="chain mb-3">Redemption Amount</h6>
                        <input type="number" required name="amount" class="form-control form-control010" id="exampleInputEmail1" placeholder="Enter Amount">
                    </div>

                    <div class="form-group mt-4">
                        <h6 class="chain mb-3">Redemption Pin</h6>
                        <input type="number" name="redemption_pin" required class="form-control form-control010" id="exampleInputEmail1" placeholder="Enter Redemption Pin">
                    </div>
                    <div class="d-flex flex-row justify-content-center mt-4">
                        <button type="submit" class="bat01">REDEMPTION</button>
                    </div>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection
@push('javascript')
<!-- <script src="{{ asset('assets/admin/lib/jquery/jquery-3.7.1.min.js') }}"></script> -->
<!-- <script src="{{ asset('assets/admin/lib/datatables/dataTables.js') }}"></script> -->
@include('layouts.includes.datatable_js')
<script>
    $(document).ready(function() {


        $(document).on("click", ".select_amount", function() {
            var amount = $(this).data('amount');
            // alert(amount);
            $('#amount').val(amount);

        });
    });
</script>
@endpush