@php
$user = \Auth::user();
@endphp
@extends('layouts.main')
@push('css')
<link rel="stylesheet" href="{{ asset('assets/front/css/usa.css') }}">
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/swiper@11/swiper-bundle.min.css" />
<link rel="stylesheet" href="{{ asset('assets/front/css/swiper.css') }}">

@endpush

@section('content')
<div class="content-wrapper">
    <!-- <div class="breadcrum">
        <a href="">
            <h3>Home /</h3>
        </a>
        <a href="">
            <h3>Destinations /</h3>
        </a>
        <a href="">
            <h3>USA</h3>
        </a>
    </div> -->

    <div class="banner">
        <h1>Extraordinary <span>USA</span> tours</h1>
        <img src="{{ asset('assets/front/images/usa-banner.webp') }}" alt="">
    </div>

    <div class="country-banner-slider">
        <div class="banner-text-cont">
            <div class="iamge-slider">
                <div class="swiper mySwiper">
                    <div class="swiper-wrapper">
                        <div class="swiper-slide"><img src="{{ asset('assets/front/images/slider1.webp') }}" alt=""></div>
                        <div class="swiper-slide"><img src="{{ asset('assets/front/images/slider2.webp') }}" alt=""></div>
                        <div class="swiper-slide"><img src="{{ asset('assets/front/images/slider3.webp') }}" alt=""></div>
                        <div class="swiper-slide"><img src="{{ asset('assets/front/images/slider4.webp') }}" alt=""></div>
                        <div class="swiper-slide"><img src="{{ asset('assets/front/images/slider5.webp') }}" alt=""></div>
                    </div>
                </div>

            </div>

            <div class="text-content">
                <p id="text">
                    Our USA holidays will take you on an epic adventure. Big-name cities, national parks, hearty cuisine and historic sights - this vast country's highlights come together like a traditional American patchwork quilt. Go west for coastal cool and canyonlands; east for small-town charm and colonial history; north for mountains and big skies; or south for musical heritage and antebellum mansions.
                    <br><br>
                    Discover the bright lights of <strong>New York, Las Vegas</strong> and San Francisco; explore southern belles like <strong>Savannah</strong>; and soak in the incredibly musicality of <strong>New Orleans</strong>, Nashville and Memphis, homes of jazz, country, rock ‘n’ roll and blues.

                    <span id="ellipsis">...</span>
                    <span id="extraText" style="display: none;">
                        Then there’s the Great Outdoors. On our USA tours, you can appreciate the awesome scenery of some of the best <strong>USA national parks</strong>, including Grand Canyon, Yellowstone and Yosemite, or journey north for the mountains, glaciers and big-sky vistas of <strong>Alaska</strong>. There’s also the tropical shores of <strong>Hawai'i</strong> and Florida to tempt you, or the idyllic scenes of <strong>New England</strong>.

                        Each of our USA itineraries has been carefully thought through, ensuring you see some of the best places to visit in the USA. As with all our holidays, our USA tours begin the moment you leave home, thanks to our award-winning <strong>VIP door-to-door travel service,</strong> while our tour managers will be on hand throughout to offer advice and make sure everything runs smoothly.
                    </span>
                </p>
                <button id="readMoreBtn">Read more <span>▼</span></button>
            </div>
        </div>
    </div>
</div>

<div class="expert-opinion">
    <div class="expert-wrapper">
        <div class="profile-section">
            <img src="{{ asset('assets/front/images/profile.webp') }}" alt="Profile Image" class="profile-image">
            <h3> Cassie Stickland </h3>
            <p>Product Manager</p>
        </div>
        <div class="content-section">
            <h2>What our experts love about USA tours</h2>
            <p>
                I particularly love California - there really isn't a bad time to visit. Particular favourites of mine are spring,
                which brings lush grass and beautiful wildflowers, and autumn, which is slightly milder and when San Francisco
                sees its sunniest days and clearest blue skies.
            </p>
        </div>
    </div>
</div>


<div class="best-places">
    <div class="best-places-container">
        <h3>What are the best places to visit in the USA?</h3>
        <p>For such a vast and diverse country, it can be truly overwhelming to pick and choose where in the USA you should explore. All our USA tours take you to on an incredible journey and to some of the America’s most iconic destinations. However, we also have USA holidays that travel to lesser-known gems. From sailing the Mississippi to road-tripping Route 66, here are just a pick of some of our favourite places in the USA.</p>


        <div class="placeBox">
            <div class="boxText">
                <h4>California</h4>
                <p>Known as the ‘Golden State’, California attracts visitors from all across the world. California, along with its neighbouring states, Nevada and Arizona, conjures images of the romantic Wild West, and our California and the Golden West tour (one of our most popular trips to America) aims to keep that Frontier spirit alive. The tour starts in LA and San Diego, before turning inland, where Yosemite.</p>

                <button class="explore-button">
                    Explore more <span><img src="{{ asset('assets/front/images/right.png') }}" alt=""></span>
                </button>
            </div>
            <div class="imgBox">
                <img src="{{ asset('assets/front/images/card1.jpg') }}" alt="">
            </div>
        </div>

        <div class="placeBox">
            <div class="imgBox">
                <img src="{{ asset('assets/front/images/card2.jpg') }}" alt="">
            </div>
            <div class="boxText">
                <h4>California</h4>
                <p>Known as the ‘Golden State’, California attracts visitors from all across the world. California, along with its neighbouring states, Nevada and Arizona, conjures images of the romantic Wild West, and our California and the Golden West tour (one of our most popular trips to America) aims to keep that Frontier spirit alive. The tour starts in LA and San Diego, before turning inland, where Yosemite.</p>

                <button class="explore-button">
                    Explore more <span><img src="{{ asset('assets/front/images/right.png') }}" alt=""></span>
                </button>
            </div>

        </div>

        <div class="placeBox">
            <div class="boxText">
                <h4>California</h4>
                <p>Known as the ‘Golden State’, California attracts visitors from all across the world. California, along with its neighbouring states, Nevada and Arizona, conjures images of the romantic Wild West, and our California and the Golden West tour (one of our most popular trips to America) aims to keep that Frontier spirit alive. The tour starts in LA and San Diego, before turning inland, where Yosemite.</p>

                <button class="explore-button">
                    Explore more <span><img src="{{ asset('assets/front/images/right.png') }}" alt=""></span>
                </button>
            </div>
            <div class="imgBox">
                <img src="{{ asset('assets/front/images/card3.jpg') }}" alt="">
            </div>
        </div>

        <div class="placeBox">
            <div class="imgBox">
                <img src="{{ asset('assets/front/images/card4.jpg') }}" alt="">
            </div>
            <div class="boxText">
                <h4>California</h4>
                <p>Known as the ‘Golden State’, California attracts visitors from all across the world. California, along with its neighbouring states, Nevada and Arizona, conjures images of the romantic Wild West, and our California and the Golden West tour (one of our most popular trips to America) aims to keep that Frontier spirit alive. The tour starts in LA and San Diego, before turning inland, where Yosemite.</p>

                <button class="explore-button">
                    Explore more <span><img src="{{ asset('assets/front/images/right.png') }}" alt=""></span>
                </button>
            </div>

        </div>
    </div>

</div>


<div class="recommendation-box">
    <h3>Recommended USA holidays</h3>
    <div class="re-wrapper">
        <div class="travel-card">
            <div class="card-image">
                <img src="{{ asset('assets/front/images/travel1.webp') }}" alt="Southern Sights and Sounds" />
            </div>
            <div class="travContent">
                <div class="card-content">
                    <h2>Southern Sights and Sounds</h2>
                    <p class="location"><span>&#x1F4CD;</span> USA</p>
                    <ul>
                        <li>● 12 nights in hotels and 1 in flight</li>
                        <li>● 5 meals included</li>
                        <li>● 15 excursions & visits</li>
                        <li>● Titan's VIP door-to-door travel service</li>
                    </ul>
                </div>
                <div>
                    <p class="duration-price">
                        <span class="duration">14 days</span> from <span class="price">£3,695pp</span>
                    </p>
                    <button class="holiday-button">
                        Holiday details <span>&#8594;</span>
                    </button>
                </div>
            </div>
        </div>
        <div class="travel-card">
            <div class="card-image">
                <img src="{{ asset('assets/front/images/travel2.webp') }}" alt="Southern Sights and Sounds" />
            </div>
            <div class="travContent">
                <div class="card-content">
                    <h2>California and the Golden West</h2>
                    <p class="location"><span>&#x1F4CD;</span> USA</p>
                    <ul>
                        <li>● 12 nights in hotels and 1 in flight</li>
                        <li>● 5 meals included</li>
                        <li>● 15 excursions & visits</li>
                        <li>● Titan's VIP door-to-door travel service</li>
                    </ul>
                </div>
                <div>
                    <p class="duration-price">
                        <span class="duration">14 days</span> from <span class="price">£3,695pp</span>
                    </p>
                    <button class="holiday-button">
                        Holiday details <span>&#8594;</span>
                    </button>
                </div>
            </div>
        </div>
        <div class="travel-card">
            <div class="card-image">
                <img src="{{ asset('assets/front/images/travel3.webp') }}" alt="Southern Sights and Sounds" />
            </div>
            <div class="travContent">
                <div class="card-content">
                    <h2>Deluxe Alaskan Voyage and Rocky Mountaineer</h2>
                    <p class="location"><span>&#x1F4CD;</span> USA</p>
                    <ul>
                        <li>● 12 nights in hotels and 1 in flight</li>
                        <li>● 5 meals included</li>
                        <li>● 15 excursions & visits</li>
                        <li>● Titan's VIP door-to-door travel service</li>
                    </ul>
                </div>
                <div>
                    <p class="duration-price">
                        <span class="duration">14 days</span> from <span class="price">£3,695pp</span>
                    </p>
                    <button class="holiday-button">
                        Holiday details <span>&#8594;</span>
                    </button>
                </div>
            </div>
        </div>

    </div>
</div>

<div class="video">
    <h3>Find out more</h3>
    <div class="video-container">
        <iframe
            width="560"
            height="315"
            src="https://www.youtube.com/embed/PoqBI3V1bfM"
            title="YouTube video player"
            frameborder="0"
            allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture"
            allowfullscreen></iframe>
    </div>


</div>

<div class="faq">
    <h3>More information about USA</h3>
    <div class="faqwrapper">
        <button class="accordion">Why visit the USA with Titan? <img class="faqArrow" src="{{ asset('assets/front/images/downArrow.png') }}" alt=""></button>
        <div class="panel">
            <p>Our USA coach tours collection is all about variety, with itineraries all over the country. You could road trip along iconic Route 66, head to the Big Apple for a few days of sightseeing and shopping, or perhaps combine your USA tour with time exploring Canada.</p>
            <br>
            <p>Whichever itinerary you choose, our dedicated tour managers will be on hand throughout to ensure everything runs perfectly, while our VIP door-to-door travel service promises to start and end your trip off in style, with a chauffeur-driven transfer to the airport.</p>
        </div>
        <button class="accordion">When is it the best time to visit the USA? <img class="faqArrow" src="{{ asset('assets/front/images/downArrow.png') }}" alt=""></button>
        <div class="panel">
            <p>Because of its vast size, the USA has varying climates and can depend on which part of the country you visit. As a rule of thumb, the best times to visit the USA are usually in the summer months – between June and September.&nbsp;&nbsp;</p>
            <p>However, if you’re going to sunnier states, including Florida, California and Arizona, then to avoid the heat, spring and autumn might be a better choice. </p>
        </div>
        <button class="accordion">What is the food and drink like in the USA? <img class="faqArrow" src="{{ asset('assets/front/images/downArrow.png') }}" alt=""></button>
        <div class="panel">
            <p>Expect huge portion sizes in the USA. Let’s just say, you won’t go hungry. It’s impossible to catergorise the food in the USA because so many of its cuisine is entrenched by the cultures that have influenced it – Chinese, Mexican, Italian, Creole, Dutch… the list goes on. From French fries, to burgers and fried chicken, key lime pie and beignets, the choice of food is endless.&nbsp;&nbsp;</p>
            <p>&nbsp;You can read more about different types of American food in <a href="" rel="noopener noreferrer" target="_blank">this blog post</a>.</p>
        </div>

        <button class="accordion">How do you manage tipping and expenses on a tour holiday in the USA?<img class="faqArrow" src="{{ asset('assets/front/images/downArrow.png') }}" alt=""></button>
        <div class="panel">
            <p><span>Tipping is ‘voluntary’ in the USA, however, it’s frowned upon if gratuities are not left. In most cases, a tip of around 15% to 25% for each transaction is considered fine and around 20% if you eat in a restaurant. For a drink at a bar, the accepted customary tip is $1 per drink. Bad service is quite rare in the USA due to the tipping culture, however, if you feel someone isn’t up to par, you should ask to speak to the manager. </span></p>
        </div>
        <button class="accordion">What are the visa requirements for the USA? <img class="faqArrow" src="{{ asset('assets/front/images/downArrow.png') }}" alt=""></button>
        <div class="panel">
            <p><span>Entry requirements to the USA are subject to change. If you’d like to find out the latest and most up to date visa rules we suggest you visit our partners CIBT. They have an accurate tool where you can check the correct information for the USA at </span>health-requirements</a><span>.&nbsp;</span></p>
        </div>
    </div>

</div>

<div class="otherDestination">
    <h3>Other popular <br> destinations</h3>
    <div class="destinationContainer">
        <div class="destBoxes">
            <div class="BoxImg"><img src="{{ asset('assets/front/images/desti1.webp') }}" alt="">
            </div>
            <h4>Alaska</h4>
        </div>
        <div class="destBoxes">
            <div class="BoxImg"><img src="{{ asset('assets/front/images/desti2.webp') }}" alt=""></div>
            <h4>Australia</h4>
        </div>
        <div class="destBoxes">
            <div class="BoxImg"><img src="{{ asset('assets/front/images/desti3.webp') }}" alt=""></div>
            <h4>Canada</h4>
        </div>
        <div class="destBoxes">
            <div class="BoxImg"><img src="{{ asset('assets/front/images/desti4.webp') }}" alt=""></div>
            <h4>Mexico</h4>
        </div>
        <div class="destBoxes">
            <div class="BoxImg"><img src="{{ asset('assets/front/images/desti5.webp') }}" alt=""></div>
            <h4>New Zealand</h4>
        </div>
        <div class="destBoxes">
            <div class="BoxImg"><img src="{{ asset('assets/front/images/desti6.webp') }}" alt=""></div>
            <h4>South Africa</h4>
        </div>

    </div>
</div>

<div class="blogSection">
    <h3>Read more about USA on our blog</h3>
    <div class="blog-container">
        <div class="blog-card">
            <img src="{{ asset('assets/front/images/blog1.webp') }}" alt="Route 66 Road" class="blog-image" />
            <div class="blog-content">
                <p class="blog-category">BLOG</p>
                <h3 class="blog-title">Texas to Arizona: Discover...</h3>
                <p class="blog-time">3 min read</p>
            </div>
        </div>
        <div class="blog-card">
            <img src="{{ asset('assets/front/images/blog2.webp') }}" alt="Route 66 Road" class="blog-image" />
            <div class="blog-content">
                <p class="blog-category">BLOG</p>
                <h3 class="blog-title">Texas to Arizona: Discover...</h3>
                <p class="blog-time">3 min read</p>
            </div>
        </div>
        <div class="blog-card">
            <img src="{{ asset('assets/front/images/blog3.webp') }}" alt="Route 66 Road" class="blog-image" />
            <div class="blog-content">
                <p class="blog-category">BLOG</p>
                <h3 class="blog-title">Texas to Arizona: Discover...</h3>
                <p class="blog-time">3 min read</p>
            </div>
        </div>

    </div>
</div>

<div class="userDet">
    <div class="userInput">
        <div class="newsletter-section">
            <h3>Receive inspiration in your inbox</h3>
            <p>Subscribe to our newsletter for holiday inspiration and the latest special offers</p>

            <form class="newsletter-form">
                <div class="input-det-wrapper">
                    <div class="input-group">
                        <div class="input-container">
                            <label for="first-name">First name</label>
                            <input type="text" id="first-name" name="first-name">
                        </div>
                        <div class="input-container">
                            <label for="last-name">Last name</label>
                            <input type="text" id="last-name" name="last-name">
                        </div>
                    </div>

                    <div class="input-container full-width">
                        <label for="email">Email</label>
                        <input type="email" id="email" name="email">
                    </div>
                </div>

                <button type="submit" class="submit-button">Submit</button>
            </form>

            <p class="privacy-text">For more information about how we use your personal information, please view our <a href="#">Privacy Policy</a>.</p>
        </div>

    </div>
</div>

<div class="whyChooseUs">
    <div class="usContainer">
        <h3>Why choose a Titan tour?</h3>
        <p>Titan Travel have always been about seeing more and doing more – which is why we meticulously plan our award-winning escorted tours so that our expertly crafted itineraries make sure that so much is included. Once you book your holiday, you can relax knowing that every element has been taken care of. Choose the tour that gives you more.</p>

        <div class="highlights">
            <div class="highlightBox">
                <img src="{{ asset('assets/front/svg/bus.svg') }}" alt="">
                <h4>VIP travel Services</h4>
                <p>Smooth transfers to and from home with unlimited mileage</p>
            </div>
            <div class="highlightBox">
                <img src="{{ asset('assets/front/svg/star.svg') }}" alt="">
                <h4>More value</h4>
                <p>From excursions to hotels, entry tickets and dining packages, we include more than any other tour.</p>
            </div>
            <div class="highlightBox">
                <img src="{{ asset('assets/front/svg/user.svg') }}" alt="">
                <h4>More knowledgeable</h4>
                <p>Be guided by some of the most passionate and knowledgeable tour managers in the world, on hand to help every step of the way.</p>
            </div>
            <div class="highlightBox">
                <img src="{{ asset('assets/front/svg/plus.svg') }}" alt="">
                <h4>More flexible</h4>
                <p>Feel free to amend or extend your travel plans, up until final payment, and enjoy free time on your tour with us too.</p>
            </div>
        </div>
    </div>
</div>
@endsection
@push('javascript')
<script src="https://cdn.jsdelivr.net/npm/swiper@11/swiper-bundle.min.js"></script>

<script src="{{ asset('assets/front/js/usascript.js') }}"></script>
<script>
    var swiper = new Swiper(".mySwiper", {
        slidesPerView: 'auto',
        spaceBetween: -20,
        navigation: {
            nextEl: ".swiper-button-next",
            prevEl: ".swiper-button-prev",
        },
    });
</script>
@endpush