@php
$user = \Auth::user();
@endphp
@extends('layouts.main')
@push('css')
<link rel="stylesheet" href="{{ asset('assets/front/css/page.css') }}">
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">

@endpush
@section('content')

<div class="bg02 pt-3 pb-3">
    <div class="container-fluid text-center">
        <div class="cont01 p-3">
            <div class="d-flex flex-row justify-content-between mb-5">
                <h1 class="dep">Deposit</h1>


                <a href="{{ route('deposite.history') }}">
                    <div class="d-flex flex-row">

                        <h1 class="dep01">Deposit History</h1>
                        <img src="{{ asset('assets/front/img/chevron02.png') }}" class="che01">
                    </div>
                </a>
            </div>
            <div class="bg-container021 p-5 mb-5">
                <h6 class="t01">Total Views</h6>
                <h1 class="t02">USDT {{ $user->balance }}</h1>

            </div>
            <h1 class=" dep01 mb-4">Deposit Amount:</h1>
                        <form method="POST" action="{{ route('send.deposite.request') }}">
                            @csrf
                            <div class="container">
                                <div class="row">
                                    <div class="col-4 select_amount" data-amount="100">
                                        <div class="card card01">
                                            <div class="card-body">
                                                <h6 class="t03">USDT</h6>
                                                <h1 class="t04">100.00</h1>
                                                <h6 class="t03">RECEIVE 100.00</h6>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="col-4 select_amount" data-amount="200">
                                        <div class="card card01">
                                            <div class="card-body">
                                                <h6 class="t03">USDT</h6>
                                                <h1 class="t04">200.00</h1>
                                                <h6 class="t03">RECEIVE 200.00</h6>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="col-4 select_amount" data-amount="500">
                                        <div class="card card01 ">
                                            <div class="card-body">
                                                <h6 class="t03">USDT</h6>
                                                <h1 class="t04">500.00</h1>
                                                <h6 class="t03">RECEIVE 500.00</h6>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <div class="form-group mt-4">

                                    <input type="number" name="amount" class="form-control form-control010" id="amount" placeholder="Enter Amount USDT 0.00" required>
                                </div>
                                <div class="d-flex flex-row justify-content-center mt-4">
                                    <button type="submit" class="bat01">SUBMIT</button>
                                </div>
                            </div>
                        </form>
                    </div>
            </div>
        </div>
        @endsection
        @push('javascript')
        <!-- <script src="{{ asset('assets/admin/lib/jquery/jquery-3.7.1.min.js') }}"></script> -->
        <!-- <script src="{{ asset('assets/admin/lib/datatables/dataTables.js') }}"></script> -->
        @include('layouts.includes.datatable_js')
        <script>
            $(document).ready(function() {


                $(document).on("click", ".select_amount", function() {
                    var amount = $(this).data('amount');
                    // alert(amount);
                    $('#amount').val(amount);

                });
            });
        </script>
        @endpush