<?php

namespace App\Http\Controllers;

use App\Facades\UtilityFacades;
use App\Models\User;
use Illuminate\Http\Request;

class FrontController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        
    }
    
    function destinations($location = ''){
        return view('front.'.$location);
    }

     function offers(){
        return view('front.offer');
    }

    function faqs()
    {
        return view('front.faqs');
    }

    function brochures()
    {
        return view('front.brochures');
    }

    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Contracts\Support\Renderable
     */
    public function index()
    {
        if (\Auth::user() && \Auth::user()->type == 'Super Admin'){
            return redirect('admin.home');
        }else{
            return view('front.home');

        }
        
    }

    public function adminLogin()
    {
        return view('front.home');
    }

    public function front()
    {

        return view('front.home');
    }
  

    public function manageWallet()
    {

        return view('front.wallet');
    }

    function order(Request $request){

        $input = $request->all();
        $user = auth()->user();

        $payment = PaytmWallet::with('receive');
        $payment->prepare([
            'order' => $input['order_id'],
            'user' => $input['CUST_ID'],
            'mobile_number' => $user->mobile,
            'email' => $user->email,
            'amount' => $input['amount'],
            'callback_url' => url('api/paytm-payment-status')
        ]);
        return $payment->receive();
    }

    public function join($id)
    {
        $tournament = Tournament::find($id);
        if ($tournament) {
            $user = auth()->user();
            if ($tournament->fees > $user->balance) {
                return redirect('/games/bgmi#upcoming-matches')->with('error', 'Insufficient Balance..!');
            } else {
                $join_details = Tournament_participants::where('match_id', $id)
                    ->where('user_id', $user->id)
                    ->first();
                $participants = Tournament_participants::where('match_id', $id)->get();
                return view('front.tournament-details', compact('tournament', 'join_details', 'participants'));
            }
        } else {
            return redirect()->back()->with('error', 'Tournament Not Exist.');
        }
    }

    function joinTournament(Request $request)
    {
        request()->validate([
            'ign' => 'required',
        ]);

        $user = auth()->user();
        $tournament = Tournament::find($request->match_id);
        if ($tournament) {
            if ($tournament->fees > $user->balance) {
                return redirect('/games/bgmi#upcoming-matches')->with('error', 'Insufficient Balance..!');
            }
            $participant = Tournament_participants::create(['ign' => $request->ign, 'match_id' => $request->match_id, 'user_id' => $user->id]);


            return redirect('/games/bgmi#upcoming-matches')
                ->with('success', __('Join successfully.'));
        } else {
            return redirect()->back()->with('error', 'Tournament Not Exist.');
        }
    }
}
