<?php

namespace App\Http\Controllers\Api;

use App\Facades\UtilityFacades;
use App\Http\Controllers\Controller;
use App\Models\Cities;
use App\Models\Meeting;
use App\Models\User;
use Illuminate\Http\Request;
use CinetPay\CinetPay;
use GuzzleHttp\Client;
use GuzzleHttp\Exception\RequestException;
use Illuminate\Support\Facades\Http;

class ApiController extends Controller
{

    public function getAuthCode(Request $request)
    {
        if ($_GET['code']) {

            $values = [
                'WEBEX_AUTH_CODE' => $_GET['code'],
            ];
            UtilityFacades::setEnvironmentValue($values);
            dd($_GET['code']);
        }
    }

    public function getAccessToken(Request $request)
    {
        // dd($request->all());
        $validator = \Validator::make($request->all(), [
            'code' => 'required',
        ]);
        if ($validator->fails()) {
            $messages = $validator->getMessageBag();
            return response()->json([
                'is_success' => false,
                'data' => ['message' => $messages->first()],
            ], 200);
        }

        $client = new Client();


        try {
            $response = $client->post('https://webexapis.com/v1/access_token', [
                'headers' => [
                    'Content-Type' => 'application/x-www-form-urlencoded',
                ],
                'form_params' => [
                    'grant_type' => 'authorization_code',
                    'client_id' => env('WEBEX_CLIENT_ID'),
                    'client_secret' => env('WEBEX_CLIENT_SECRET'),
                    'code' => $request->code,
                    'redirect_uri' => env('WEBEX_REDIRECT_URI'),
                ],
            ]);

            $data = json_decode($response->getBody(), true);
            // dd($data);
            $values = [
                'WEBEX_ACCESS_TOKEN' => $data['access_token'],
                'WEBEX_REFRESH_TOKEN' => $data['refresh_token'],
                'WEBEX_SCOPE' => $data['scope'],
            ];
            UtilityFacades::setEnvironmentValue($values);
            // dd($values);
            return response()->json([
                'is_success' => true,
                'data' => $values,
            ], 200);
            // dd(env('WEBEX_ACCESS_TOKEN'));
        } catch (RequestException $e) {
            if ($e->hasResponse()) {
                $response = $e->getResponse();
                $statusCode = $response->getStatusCode();
                $errorMessage = json_decode($response->getBody(), true)['message'] ?? 'Unknown Error';
                $errors = json_decode($response->getBody(), true)['errors'] ?? [];

                // Prepare error response
                $errorResponse = [
                    'error' => [
                        'message' => $errorMessage,
                        'status_code' => $statusCode,
                        'errors' => $errors,
                    ]
                ];
                // dd($errorResponse);

                // Return error response as JSON
                return response()->json(
                    $errorResponse,
                    $statusCode
                );
            } else {
                // Handle other types of exceptions
            }
        }
    }

    public function refreshAccessToken()
    {
        $client = new Client();


        try {
            $response = $client->post('https://webexapis.com/v1/access_token', [
                'headers' => [
                    'Content-Type' => 'application/x-www-form-urlencoded',
                ],
                'form_params' => [
                    'grant_type' => 'refresh_token',
                    'client_id' => env('WEBEX_CLIENT_ID'),
                    'client_secret' => env('WEBEX_CLIENT_SECRET'),
                    'refresh_token' => env('WEBEX_REFRESH_TOKEN'),
                ],
            ]);

            $data = json_decode($response->getBody(), true);
            // dd($data);
            $values = [
                'WEBEX_ACCESS_TOKEN' => $data['access_token'],
                'WEBEX_REFRESH_TOKEN' => $data['refresh_token'],
                'WEBEX_SCOPE' => $data['scope'],
            ];
            UtilityFacades::setEnvironmentValue($values);
            // dd($values);
            return response()->json([
                'is_success' => true,
                'data' => $values,
            ], 200);
            // dd(env('WEBEX_ACCESS_TOKEN'));
        } catch (RequestException $e) {
            if ($e->hasResponse()) {
                $response = $e->getResponse();
                $statusCode = $response->getStatusCode();
                $errorMessage = json_decode($response->getBody(), true)['message'] ?? 'Unknown Error';
                $errors = json_decode($response->getBody(), true)['errors'] ?? [];

                // Prepare error response
                $errorResponse = [
                    'error' => [
                        'message' => $errorMessage,
                        'status_code' => $statusCode,
                        'errors' => $errors,
                    ]
                ];
                // dd($errorResponse);

                // Return error response as JSON
                return response()->json(
                    $errorResponse,
                    $statusCode
                );
            } else {
                // Handle other types of exceptions
            }
        }
    }
    
    


    function createMeeting(Request $request)
    {
        $validator = \Validator::make($request->all(), [
            'title' => 'required',
            'agenda' => 'required',
            'start' => 'required',
            'end' => 'required',
        ]);
        if ($validator->fails()) {
            $messages = $validator->getMessageBag();
            return response()->json([
                'is_success' => false,
                'data' => ['message' => $messages->first()],
            ], 200);
        }

        $this->refreshAccessToken();

        try {

            $client = new Client();


            
            $response = $client->post('https://webexapis.com/v1/meetings', [
                'headers' => [
                    'Authorization' => 'Bearer ' . env('WEBEX_ACCESS_TOKEN'),
                    'Content-Type' => 'application/json',
                ],
                'json' => [
                    'title' => $request->title,
                    'agenda' => $request->agenda,
                    'start' => $request->start,
                    'end' => $request->end,
                    'enabledAutoRecordMeeting' => false,
                    'allowAnyUserToBeCoHost' => true,
                    'enabledViewParticipantList' => false,
                    'enabledChatOtherParticipants' => false
                ]
            ]);
            
            $res = json_decode($response->getBody());

            $meeting = new Meeting();
            $meeting->meeting_id = $res->id;
            $meeting->meeting_number = $res->meetingNumber;
            $meeting->title = $res->title;
            $meeting->agenda = $res->agenda;
            $meeting->password = $res->password;
            $meeting->meeting_link = $res->webLink;
            

            $meeting->save();

            return response()->json([
                'is_success' => true,
                'data' => $res,
            ], 200);

        } catch (RequestException $e) {
            if ($e->hasResponse()) {
                $response = $e->getResponse();
                $statusCode = $response->getStatusCode();
                $errorMessage = json_decode($response->getBody(), true)['message'] ?? 'Unknown Error';
                $errors = json_decode($response->getBody(), true)['errors'] ?? [];

                
                $errorResponse = [
                    'error' => [
                        'message' => $errorMessage,
                        'status_code' => $statusCode,
                        'errors' => $errors,
                    ]
                ];
              
               
                return response()->json(
                    $errorResponse,
                    $statusCode
                );
            } else {
                
            }
        }
    }
}
