<?php

namespace App\DataTables;

use App\Facades\UtilityFacades;
use App\Models\User;
use Illuminate\Http\Request;
use Yajra\DataTables\Html\Button;
use Yajra\DataTables\Html\Column;
use Yajra\DataTables\Html\Editor\Editor;
use Yajra\DataTables\Html\Editor\Fields;
use Yajra\DataTables\Services\DataTable;

class AgencyDataTable extends DataTable
{
    /**
     * Build DataTable class.
     *
     * @param mixed $query Results from query() method.
     * @return \Yajra\DataTables\DataTableAbstract
     */
    public function dataTable($query)
    {
        return datatables()
            ->eloquent($query)
           
            ->addColumn('role', function (User $user) {
                $out = '';
                if (!empty($user->getRoleNames())) {
                    foreach ($user->getRoleNames() as $v) {

                        $out = '<label class="badge badge-primary">' . $v . '</label>';
                    }
                }
                return $out;
            })
            ->editColumn('created_at', function (User $user) {
                return UtilityFacades::date_time_format($user->created_at);
            })
            ->addColumn('action', function (User $user) {
                return view('users.action', compact('user'));
            })

            ->rawColumns(['role', 'action']);
       
    }

    /**
     * Get query source of dataTable.
     *
     * @param \App\User $model
     * @return \Illuminate\Database\Eloquent\Builder
     */
    public function query(User $model, Request $request)
    {

        $users =  $model->newQuery()->where('type','Agent');
        if ($request->username) {
            $users->where('username', 'like', '%' . $request->username . '%');
        }
        if ($request->mobile_number) {
            $users->where('mobile_number', 'like', '%' . $request->mobile_number . '%');
        }
        if ($request->r_date) {
            // dd($request->r_date);
            $users->whereDate('created_at', '=', $request->r_date);
        }
        return $users;
    }

    /**
     * Optional method if you want to use html builder.
     *
     * @return \Yajra\DataTables\Html\Builder
     */
    public function html()
    {
        return $this->builder()
            ->setTableId('users-table')
            ->columns($this->getColumns())
            ->minifiedAjax()
            ->orderBy(1)
            ->language([
                "paginate" => [
                    "next" => '<i class="fas fa-angle-right"></i>',
                    "previous" => '<i class="fas fa-angle-left"></i>'
                ]
            ])
            ->parameters([
                "scrollX" => true
            ]);
    }

    /**
     * Get columns.
     *
     * @return array
     */
    protected function getColumns()
    {
        return [

            Column::make('id'),
            Column::make('username'),
            Column::make('balance'),
            Column::make('referral_by'),
            Column::make('mobile_number'),
            Column::make('referral_code'),
            Column::make('created_at'),

            Column::computed('action')
                ->exportable(false)
                ->printable(false)
                ->width(5000)
                ->addClass('text-center'),
    
            
           
        ];
    }

    /**
     * Get filename for export.
     *
     * @return string
     */
    // protected function filename()
    // {
    //     return 'Users_' . date('YmdHis');
    // }
}
